const footer = require('../../models/footer');
const social = require('../../models/social');
const company = require('../../models/company');
const country = require('../../models/country');

const helper = require('../../helper');
const express = require("express");
const bodyParser = require("body-parser");
const router = express.Router();
const config = require("../../config")
//var jsonParser = bodyParser.json()
//var urlencodedParser = bodyParser.urlencoded({ extended: false })
const app = express();
app.use(express.json());

router.post("/footer", async (req, res, next) => {
     if(helper.check_headers(req) == "True"){
        var footer_data = await  footer.get_footer()
        footer_data.image1 = config.baxter_url+"uploads/homepage/"+footer_data.image
        footer_data.footer_image = config.baxter_url+"uploads/homepage/"+footer_data.footer_image
        var social_links_data = await social.get_social_links()

        var company_data = await company.get_company()
        var company_details = {
            contact:company_data.company_contact,
            address:company_data.company_address,
            city:company_data.company_city,
            state:company_data.company_state,
            country:await country.get_country_name(company_data.company_country),
            company_white_logo:config.baxter_url+"images/logo/"+company_data.company_white_logo,
            company_logo:config.baxter_url+"images/logo/"+company_data.company_logo,
            company_email:company_data.company_email,
            company_web:company_data.company_web,
        }
        

        var app_store_link = await social.get_store_app_link();
        app_store_link.playstoreimage = config.baxter_url+"uploads/homepage/"+app_store_link.playstoreimage
        app_store_link.applestoreimage = config.baxter_url+"uploads/homepage/"+app_store_link.applestoreimage

        res.status(200).json({
            message: "Successfull",
            status: "True",
            data:{
                footer: footer_data,
                social_links:social_links_data,
                company_data:company_details,
                app_store_link:app_store_link
            }
        });
     }else{
        res.status(200).json({
            message: "Unauthorised request",
            status: "Fail"
        });
     }
});

module.exports = router;