
const bodyParser = require('body-parser');
const morgan = require("morgan");
var cors = require('cors');
const express = require('express');
const app = express();
app.use(cors())

app.use((req, res, next) => {
    res.header("Access-Control-Allow-Origin", "*");
    res.header(
        "Access-Control-Allow-Headers",
        "Origin, X-Requested-With, Content-Type, Accept, Authorization"
    );
    if (req.method === 'OPTIONS') {
        res.header('Access-Control-Allow-Methods', 'PUT, POST, PATCH, DELETE, GET');
        return res.status(200).json({});
    }
    next();
});

const loader = require('./components/loader/loader');
app.use('/loader',loader);

 const dashboard = require("./components/dashboard/dashboard");
 app.use("/dashboard", dashboard);

 const feature = require("./components/features/features");
 app.use("/feature", feature);

 const eligibility = require("./components/eligibility/eligibility");
 app.use("/eligibility", eligibility);

 const borrow = require("./components/borrow/borrow");
 app.use("/borrow", borrow);

 const deposit = require("./components/deposit/deposit");
 app.use("/deposit", deposit);

 const invest = require("./components/invest/invest");
 app.use("/invest", invest);

 const about = require("./components/about/about");
 app.use("/about", about);

 const help = require("./components/help/help");
 app.use("/help", help);

 const footer = require("./components/footer/footer");
 app.use("/footer", footer);

 const header = require("./components/header/header");
 app.use("/header", header);

 const test = require("./components/dashboard/head");
 app.use("/test", test);
 
// const adm_route = require("./components/login/user");
// app.use("/user_login", adm_route);





// app.use((error, req, res, next) => {
//     res.status(error.status || 500);
//     res.json({
//         error: {
//             message: error.message
//         }
//     });
// });

module.exports = app;