'use strict';

var IntN = require('./intn');

module.exports = {
  id: 0x38,
  type: 'INT4',
  name: 'Int',

  declaration: function declaration() {
    return 'int';
  },

  writeTypeInfo: function writeTypeInfo(buffer) {
    buffer.writeUInt8(IntN.id);
    buffer.writeUInt8(4);
  },

  writeParameterData: function writeParameterData(buffer, parameter) {
    if (parameter.value != null) {
      buffer.writeUInt8(4);
      buffer.writeInt32LE(parseInt(parameter.value));
    } else {
      buffer.writeUInt8(0);
    }
  },

  validate: function validate(value) {
    if (value == null) {
      return null;
    }
    value = parseInt(value);
    if (isNaN(value)) {
      return new TypeError('Invalid number.');
    }
    if (value < -2147483648 || value > 2147483647) {
      return new TypeError('Value must be between -2147483648 and 2147483647.');
    }
    return value;
  }
};