const config = require('../config')
const pre = config.database.pre
const QueryBuilder = require('node-querybuilder');
const pool = new QueryBuilder(config.settings, 'mysql', 'pool');


  async function faqs() {
    try {
        let qb = await pool.get_connection();
        let response = await qb.select('*').where('deleted', '0').get(pre+'_faq');
        qb.release();
        return response;
    } catch (err) {
        return "Fail";
    }
  }

  async function heading() {
    try {
        let qb = await pool.get_connection();
        let response = await qb.select('*').get(pre+'_homepage_section4_title');
        qb.release();
        return response[0];
    } catch (err) {
        return "Fail";
    }
  }

module.exports = {
    faqs,heading
}

/* 

INSTRUCTIONS
===================

1. Query Builder Reference : https://www.npmjs.com/package/node-querybuilder#how-to-install

*/